/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols.listeners;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.listeners.IoTListener;

public class IoTMonitoringService {
    private static IoTMonitoringService instance;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t2 = new Thread(r);
        t2.setDaemon(true);
        return t2;
    });
    private final Map<Runnable, ScheduledFuture<?>> activeTasks = new ConcurrentHashMap();

    public static IoTMonitoringService getInstance() {
        if (instance == null) {
            instance = new IoTMonitoringService();
        }
        return instance;
    }

    public <R, T> void registerIoTListener(IoTListener<R, T> listener) {
        ScheduledFuture<?> future = this.executor.scheduleWithFixedDelay(listener, 0L, 50L, TimeUnit.MILLISECONDS);
        this.activeTasks.put(listener, future);
    }

    public void unregisterListener(Runnable listener) {
        ScheduledFuture<?> f = this.activeTasks.remove(listener);
        if (f != null) {
            f.cancel(true);
        }
    }

    public void unregisterAll() {
        this.activeTasks.values().forEach(f -> f.cancel(true));
        this.activeTasks.clear();
    }

    public void shutdown() {
        this.unregisterAll();
        this.executor.shutdown();
    }
}

