/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceType;

public class I2CScanner {
    private static final Logger logger = LogManager.getLogger(I2CScanner.class);
    private static final int SCAN_INTERVAL_MS = 60000;
    private static I2CScanner instance;
    Set<DeviceType> connectedDevices = new HashSet<DeviceType>();
    private static long lastScan;

    private I2CScanner() {
        lastScan = 0L;
    }

    public static I2CScanner getInstance() {
        if (instance == null) {
            instance = new I2CScanner();
        }
        return instance;
    }

    public static Set<DeviceType> scan() {
        lastScan = System.currentTimeMillis();
        HashSet<DeviceType> devices = new HashSet<DeviceType>();
        try {
            String line;
            Process proc = new ProcessBuilder("i2cdetect", "-y", String.valueOf(1)).start();
            InputStreamReader isr = new InputStreamReader(proc.getInputStream());
            BufferedReader r = new BufferedReader(isr);
            while ((line = r.readLine()) != null) {
                String[] addrs;
                String[] parts = line.split(":");
                if (parts.length <= 1) continue;
                for (String addr : addrs = parts[1].split("\\s+")) {
                    if (addr.length() != 2 || addr.equals("--")) continue;
                    int device_addr = Integer.parseInt(addr, 16);
                    devices.add(I2CScanner.getI2CAddressDevice(device_addr));
                }
            }
            proc.waitFor();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return devices;
    }

    public void detectDeviceActivity(Set<DeviceType> inUse) {
        this.probeDevices(inUse, true);
    }

    public void detectDeviceActivity() {
        this.probeDevices(I2CScanner.scan(), false);
    }

    private synchronized void probeDevices(Set<DeviceType> currentDevices, boolean inUse) {
        String addr_hex;
        for (DeviceType device : currentDevices) {
            if (!this.connectedDevices.add(device)) continue;
            addr_hex = I2CScanner.getDeviceI2CAddressHex(device);
            logger.info("New device added at I2C address: " + addr_hex);
        }
        for (DeviceType device : this.connectedDevices) {
            if (currentDevices.contains((Object)device)) continue;
            addr_hex = I2CScanner.getDeviceI2CAddressHex(device);
            if (inUse) {
                logger.info("Disconnected device that was in use at I2C address: " + addr_hex);
            } else {
                logger.info("Disconnected device at I2C address: " + addr_hex);
            }
            this.connectedDevices.remove((Object)device);
        }
    }

    private boolean scanAgain() {
        return System.currentTimeMillis() - lastScan >= 60000L;
    }

    public Set<DeviceType> getConnectedDevices() {
        return this.getConnectedDevices(this.scanAgain());
    }

    public List<Integer> getConnectedDeviceI2CAddresses() {
        return this.getConnectedDeviceI2CAddresses(this.scanAgain());
    }

    public Set<DeviceType> getConnectedDevices(boolean refresh) {
        if (refresh) {
            this.detectDeviceActivity();
        }
        return this.connectedDevices;
    }

    public List<Integer> getConnectedDeviceI2CAddresses(boolean refresh) {
        if (refresh) {
            this.detectDeviceActivity();
        }
        return this.connectedDevices.stream().map(d -> I2CScanner.getDeviceI2CAddress(d)).filter(Objects::nonNull).toList();
    }

    public static Integer getDeviceI2CAddress(DeviceType type) {
        switch (type) {
            case GROVE_LED_MATRIX: {
                return 101;
            }
            case GROVE_LCD: {
                return 62;
            }
            case GROVE_GESTURE_DETECTOR: {
                return 115;
            }
            case GROVE_3AXIS_ACCELEROMETER: {
                return 76;
            }
        }
        return null;
    }

    public static DeviceType getI2CAddressDevice(int addr) {
        switch (addr) {
            case 101: {
                return DeviceType.GROVE_LED_MATRIX;
            }
            case 62: {
                return DeviceType.GROVE_LCD;
            }
            case 115: {
                return DeviceType.GROVE_GESTURE_DETECTOR;
            }
            case 76: {
                return DeviceType.GROVE_3AXIS_ACCELEROMETER;
            }
        }
        return null;
    }

    public static String getDeviceI2CAddressHex(DeviceType type) {
        switch (type) {
            case GROVE_LED_MATRIX: {
                return Integer.toHexString(101);
            }
            case GROVE_LCD: {
                return Integer.toHexString(62);
            }
            case GROVE_GESTURE_DETECTOR: {
                return Integer.toHexString(115);
            }
            case GROVE_3AXIS_ACCELEROMETER: {
                return Integer.toHexString(76);
            }
        }
        return null;
    }
}

