/*
 * Decompiled with CFR 0.152.
 */
package tardis.app;

import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.OverlaySize;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.micro.protocols.iot.remote.requests.ExportIoTDeviceRequest;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.BroadcastDelivery;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.requests.BroadcastRequest;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLedMatrix;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceType;
import pt.unl.fct.di.tardis.babel.iot.api.replies.RegisterIoTDeviceReply;
import pt.unl.fct.di.tardis.babel.iot.api.requests.RegisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetDisplayColorRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.SetMultipleChainableLEDColorRGBRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowAnimationRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowEmojiRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.output.ShowTextRequest;
import tardis.app.data.UserMessage;
import tardis.app.timers.AppWorkloadGenerateTimer;

public class DataDisseminationApp
extends GenericProtocol {
    public static final String PROTO_NAME = "TaRDIS Simple App";
    public static final short PROTO_ID = 9999;
    public static final String PAR_GENERATE_WORKLOAD = "app.automatic";
    private boolean generateWorkload;
    public static final String PAR_WORKLOAD_PERIOD = "app.workload.period";
    public static final String PAR_WOKRLOAD_SIZE = "app.workload.payload";
    public static final long DEFAULT_WORKLOAD_PERIOD = 10000L;
    public static final int DEFAULT_WORKLOAD_SIZE = 63000;
    public static final String PAR_WORKLOAD_PROBABILITY = "app.workload.probability";
    public static final double DEFAULT_WORKLOAD_PROBABILITY = 1.0;
    public static final String PAR_BCAST_PROTOCOL_ID = "app.bcast.id";
    public static final String PAR_BCAST_INIT_ENABLED = "app.bcast.enable";
    public static final boolean DEFAULT_BCAST_INIT_ENABLED = true;
    public static final String PAR_IOT_REMOTE_PROTO_ID = "app.iot.remote";
    public static final short DEFAULT_IOT_REMOTE_PROTO_ID = 15000;
    private long workloadPeriod;
    private int payloadSize;
    private double generateMessageProbability;
    private short bcastProtoID;
    private final Host myself;
    private Logger logger = LogManager.getLogger(DataDisseminationApp.class);
    private AtomicBoolean executing;
    private String nodeLabel;
    private long networkSizeEstimation;
    private int numberOfNeighbors;
    private DeviceHandle matrixDevice;
    private DeviceHandle lcdDevice;
    private DeviceHandle ledDevice;
    private static final String MATRIX_ALIAS = "Matrix";
    private static final String LCD_ALIAS = "LCD";
    private static final String LED_ALIAS = "Led";

    public DataDisseminationApp(Host myself) throws HandlerRegistrationException, IOException {
        super(PROTO_NAME, (short)9999);
        this.myself = myself;
        try {
            this.nodeLabel = myself.getAddress().getHostName().split("\\.")[3];
        }
        catch (Exception e) {
            this.nodeLabel = myself.getAddress().getHostName();
        }
        this.networkSizeEstimation = -1L;
        this.registerTimerHandler((short)9999, this::handleAppWorkloadGenerateTimer);
        this.subscribeNotification((short)501, this::handleDMessageDeliveryEvent);
        this.subscribeNotification((short)701, this::handleNetworkSizeEstimationNotification);
        this.subscribeNotification((short)401, this::handleNeighborUpNotification);
        this.subscribeNotification((short)402, this::handleNeighborDownNotification);
        this.numberOfNeighbors = 0;
        this.registerReplyHandler((short)4010, this::handleRegisterIoTDeviceReply);
    }

    @Override
    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (props.containsKey(PAR_BCAST_PROTOCOL_ID)) {
            this.bcastProtoID = Short.parseShort(props.getProperty(PAR_BCAST_PROTOCOL_ID));
            this.logger.debug("DataDisseminationApp is configured to used broadcast protocol with id: " + this.bcastProtoID);
        } else {
            this.logger.error("The applicaiton requires the id of the broadcast protocol being used. Parameter: 'app.bcast.id'");
            System.exit(1);
        }
        this.sendRequest(new RegisterIoTDeviceRequest(DeviceType.GROVE_LED_MATRIX, MATRIX_ALIAS), (short)4000);
        this.sendRequest(new RegisterIoTDeviceRequest(DeviceType.GROVE_LCD, LCD_ALIAS), (short)4000);
        this.sendRequest(new RegisterIoTDeviceRequest(DeviceType.GROVE_CHAINABLE_RGB, LED_ALIAS, 26), (short)4003);
        this.generateWorkload = props.containsKey(PAR_GENERATE_WORKLOAD);
        if (this.generateWorkload) {
            this.workloadPeriod = props.containsKey(PAR_WORKLOAD_PERIOD) ? Long.parseLong(props.getProperty(PAR_WORKLOAD_PERIOD)) : 10000L;
            this.payloadSize = props.containsKey(PAR_WOKRLOAD_SIZE) ? Integer.parseInt(props.getProperty(PAR_WOKRLOAD_SIZE)) : 63000;
            this.generateMessageProbability = props.containsKey(PAR_WORKLOAD_PROBABILITY) ? Double.parseDouble(props.getProperty(PAR_WORKLOAD_PROBABILITY)) : 1.0;
            this.setupPeriodicTimer(new AppWorkloadGenerateTimer(), this.workloadPeriod, this.workloadPeriod);
            this.logger.debug("DataDisseminationApp has workload generation enabled.");
        } else {
            this.logger.debug("DataDisseminationApp has workload generation disabled.");
        }
        boolean b = true;
        if (props.containsKey(PAR_BCAST_INIT_ENABLED)) {
            b = Boolean.parseBoolean(props.getProperty(PAR_BCAST_INIT_ENABLED));
        }
        this.executing = new AtomicBoolean(b);
    }

    public void handleRegisterIoTDeviceReply(RegisterIoTDeviceReply rep, short protocolId) {
        System.err.println(" ====> Received a RegisterIoTDevice Reply: " + String.valueOf((Object)rep.getDeviceType()) + "(" + rep.getDeviceAlias() + ")");
        ExportIoTDeviceRequest export = null;
        if (rep.isSuccessful()) {
            if (rep.getDeviceType() == DeviceType.GROVE_LCD) {
                this.lcdDevice = rep.getDeviceHandle();
                if (!this.lcdDevice.getDeviceAlias().equals(LCD_ALIAS)) {
                    System.err.println("Incorrect answer received, expected alias 'LCD' received '" + this.lcdDevice.getDeviceAlias() + "'");
                    System.exit(1);
                }
                export = new ExportIoTDeviceRequest(3, this.lcdDevice);
                this.sendRequest(new ShowTextRequest(this.lcdDevice, ""), (short)4000);
                this.logger.debug("Registerd IoT Device GROVE_LCD");
            } else if (rep.getDeviceType() == DeviceType.GROVE_LED_MATRIX) {
                this.matrixDevice = rep.getDeviceHandle();
                if (!this.matrixDevice.getDeviceAlias().equals(MATRIX_ALIAS)) {
                    System.err.println("Incorrect answer received, expected alias 'Matrix' received '" + this.matrixDevice.getDeviceAlias() + "'");
                    System.exit(1);
                }
                export = new ExportIoTDeviceRequest(2, this.matrixDevice);
                this.sendRequest(new SetDisplayColorRequest(this.matrixDevice, 0, 255, 0), (short)4000);
            } else if (rep.getDeviceType() == DeviceType.GROVE_CHAINABLE_RGB) {
                this.ledDevice = rep.getDeviceHandle();
                if (!this.ledDevice.getDeviceAlias().equals(LED_ALIAS)) {
                    System.err.println("Incorrect answer received, expected alias 'Led' received '" + this.ledDevice.getDeviceAlias() + "'");
                    System.exit(1);
                }
                export = new ExportIoTDeviceRequest(1, this.ledDevice);
                SetMultipleChainableLEDColorRGBRequest req = new SetMultipleChainableLEDColorRGBRequest(this.ledDevice);
                req.setValuesForPosition((byte)0, (byte)0, (byte)0, (byte)0);
                this.sendRequest(req, (short)4003);
            } else {
                System.err.println("Unknown Device was registered: " + String.valueOf((Object)rep.getDeviceType()) + "(" + rep.getDeviceAlias() + ")");
            }
            if (export != null) {
                System.err.println(" ====> Registering the LED device on the IoTRemoveControlProtocol");
                this.sendRequest(export, (short)17000);
            }
        } else {
            System.err.println("Failed to register Device: " + String.valueOf((Object)rep.getDeviceType()) + " (" + rep.getDeviceAlias() + ") error: " + rep.getErrorMessage());
        }
    }

    private void handleAppWorkloadGenerateTimer(AppWorkloadGenerateTimer t2, long time) {
        if (!this.executing.getAcquire()) {
            return;
        }
        if (this.generateMessageProbability < 1.0) {
            Random random = new Random();
            if (random.nextDouble() > this.generateMessageProbability) {
                return;
            }
        }
        this.logger.debug("DataDisseminationApp generating workload.");
        String payload = DataDisseminationApp.randomCapitalLetters(this.payloadSize);
        String msg = this.myself.getAddress().getHostName() + " Memory Usage " + Runtime.getRuntime().totalMemory() + " Available CPUs: " + Runtime.getRuntime().availableProcessors();
        msg = this.networkSizeEstimation > 0L ? msg + " Local swarm size estimation: " + this.networkSizeEstimation : msg + " No local swarm size estimation yet.";
        UserMessage message = new UserMessage(this.myself.toString(), this.nodeLabel + "-bot", msg, DataDisseminationApp.readableOutput(payload) + ".txt", payload.getBytes());
        byte[] data = null;
        try {
            data = message.toByteArray();
        }
        catch (Exception e) {
            this.logger.error("Failed to serialize UserMessage, falling back to String", (Throwable)e);
            data = payload.getBytes();
            message = null;
        }
        BroadcastRequest request = new BroadcastRequest(this.myself, data, 9999);
        this.sendRequest(request, this.bcastProtoID);
        if (message == null) {
            this.logger.info(String.valueOf(this.myself) + " sent message: [" + String.valueOf(this.myself) + "::::" + DataDisseminationApp.readableOutput(payload) + "]");
        } else if (message.hasAttachment()) {
            this.logger.info(String.valueOf(this.myself) + " sent message: [" + String.valueOf(this.myself) + "::::" + DataDisseminationApp.readableOutput(message.getMessage(), message.getAttachmentName()) + "]");
        } else {
            this.logger.info(String.valueOf(this.myself) + " sent message: [" + String.valueOf(this.myself) + "::::" + DataDisseminationApp.readableOutput(message.getMessage()) + "]");
        }
    }

    private void handleDMessageDeliveryEvent(BroadcastDelivery msg, short proto) {
        Object payload = null;
        UserMessage um = null;
        try {
            um = UserMessage.fromByteArray(msg.getPayload());
        }
        catch (Exception e) {
            return;
        }
        if (um.hasAttachment()) {
            this.logger.info(String.valueOf(this.myself) + " recv message: [" + String.valueOf(msg.getSender()) + "::::" + DataDisseminationApp.readableOutput(um.getMessage(), um.getAttachmentName()) + "]");
        } else {
            this.logger.info(String.valueOf(this.myself) + " recv message: [" + String.valueOf(msg.getSender()) + "::::" + DataDisseminationApp.readableOutput(um.getMessage()) + "]");
        }
        if (this.lcdDevice != null) {
            this.sendRequest(new ShowTextRequest(this.lcdDevice, "Just got a message from: " + um.getAlias()), (short)4000);
        }
        String text = um.getMessage().trim().toLowerCase();
        if (this.matrixDevice != null) {
            if (text.contains("smile")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Smile), (short)4000);
            } else if (text.contains("cat")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Cat), (short)4000);
            } else if (text.contains("tardis") || text.contains("explode")) {
                this.sendRequest(new ShowAnimationRequest(this.matrixDevice, GroveLedMatrix.Animation.Fire), (short)4000);
            } else if (text.contains("lidija") || text.contains("rainbow")) {
                this.sendRequest(new ShowAnimationRequest(this.matrixDevice, GroveLedMatrix.Animation.Rainbow), (short)4000);
            } else if (text.contains("borja") || text.contains("time")) {
                this.sendRequest(new ShowAnimationRequest(this.matrixDevice, GroveLedMatrix.Animation.BigClock), (short)4000);
            } else if (text.contains("joao") || text.contains("leitao") || text.contains("angry")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Angry), (short)4000);
            } else if (text.contains("dimitra") || text.contains("flower")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Flower), (short)4000);
            } else if (text.contains("carla") || text.contains("heart")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Heart), (short)4000);
            } else if (text.contains("nuno") || text.contains("rabbit")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Rabbit), (short)4000);
            } else if (text.contains("alceste") || text.contains("monster")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Monster), (short)4000);
            } else if (text.contains("milos") || text.contains("crystal")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.CrystalSword), (short)4000);
            } else if (text.contains("silvia") || text.contains("tree")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Tree), (short)4000);
            } else if (text.contains("seco") || text.contains("rain")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Rain), (short)4000);
            } else if (text.contains("giovanni") || text.contains("fire")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Flame), (short)4000);
            } else if (text.contains("panos") || text.contains("awkward")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Awkward), (short)4000);
            } else if (text.contains("miroslav") || text.contains("crab")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Crab), (short)4000);
            } else if (text.contains("claudia") || text.contains("cry")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Cry), (short)4000);
            } else if (text.contains("ivan") || text.contains("duck")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Duck), (short)4000);
            } else if (text.contains("david") || text.contains("small hearth")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.SmallHeart), (short)4000);
            } else if (text.contains("bordalo") || text.contains("creeper")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Creeper), (short)4000);
            } else if (text.contains("carlos") || text.contains("money")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Greedy), (short)4000);
            } else if (text.contains("nobuko") || text.contains("house")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.House), (short)4000);
            } else if (text.contains("miguel") || text.contains("lol") || text.contains("laught")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Laught), (short)4000);
            } else if (text.contains("bruno") || text.contains("brokenheart")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.BrokenHeart), (short)4000);
            } else if (text.contains("antonio") || text.contains("mad")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Mad), (short)4000);
            } else if (text.contains("diogo") || text.contains("umbrella")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Umbrella), (short)4000);
            } else if (text.contains("sebastian") || text.contains("shy")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Shy), (short)4000);
            } else if (text.contains("luis") || text.contains("waterdrop")) {
                this.sendRequest(new ShowEmojiRequest(this.matrixDevice, GroveLedMatrix.Emoji.Waterdrop), (short)4000);
            }
        }
    }

    public void handleNeighborUpNotification(NeighborUp not, short proto) {
        ++this.numberOfNeighbors;
        this.sendRequest(new ShowAnimationRequest(this.matrixDevice, GroveLedMatrix.Animation.WalkingChild), (short)4000);
        this.sendRequest(new ShowTextRequest(this.lcdDevice, "New neighbor: " + not.getPeer().toString() + " (current neighbor count: " + this.numberOfNeighbors + ")"), (short)4000);
    }

    public void handleNeighborDownNotification(NeighborDown not, short proto) {
        --this.numberOfNeighbors;
        this.sendRequest(new ShowAnimationRequest(this.matrixDevice, GroveLedMatrix.Animation.BrokenHeart), (short)4000);
        this.sendRequest(new ShowTextRequest(this.lcdDevice, "Lost neighbor: " + not.getPeer().toString() + " (current neighbor count: " + this.numberOfNeighbors + ")"), (short)4000);
    }

    public void handleNetworkSizeEstimationNotification(OverlaySize not, short proto) {
        this.networkSizeEstimation = not.getSize();
        this.sendRequest(new ShowTextRequest(this.lcdDevice, "Network Size Estimation: " + this.networkSizeEstimation), (short)4000);
    }

    public static String randomCapitalLetters(int length) {
        int leftLimit = 65;
        int rightLimit = 90;
        Random random = new Random();
        return random.ints(leftLimit, rightLimit + 1).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String readableOutput(String msg, String attachName) {
        return Hashing.sha256().hashString(msg + "::" + attachName, StandardCharsets.UTF_8).toString();
    }

    public static String readableOutput(String msg) {
        if (msg.length() > 32) {
            return Hashing.sha256().hashString(msg, StandardCharsets.UTF_8).toString();
        }
        return msg;
    }

    public void disableTransmissions() {
        this.executing.set(false);
    }

    public boolean isTransmitting() {
        return this.executing.get();
    }

    public void enableTransmission() {
        this.executing.set(true);
    }

    public void shutdown() {
        this.sendRequest(new SetDisplayColorRequest(this.matrixDevice, 255, 0, 0), (short)4000);
        this.sendRequest(new ShowTextRequest(this.lcdDevice, "Bye bye!"), (short)4000);
    }
}

