/*
 * Decompiled with CFR 0.152.
 */
package tardis.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.TreeSet;

public class CheckSecureMessageDelivery {
    private int numberOfProcesses = 0;
    private HashMap<String, DataUnit> transmissionTime;
    private HashMap<String, HashSet<DataUnit>> receptionTimes;
    private TreeSet<DataUnit> orderedTransmissions = new TreeSet();
    private ArrayList<Long> lantenciesOverTime;
    private ArrayList<Double> reliabilityOverTime;
    private double averageLatency;
    private double averageReliability;
    private long inconsistentRecords;

    public CheckSecureMessageDelivery() {
        this.transmissionTime = new HashMap();
        this.receptionTimes = new HashMap();
        this.lantenciesOverTime = new ArrayList();
        this.reliabilityOverTime = new ArrayList();
    }

    public void addLogFile(String filename) throws Exception {
        try (Scanner sc = new Scanner(new File(filename));){
            int l = 0;
            while (sc.hasNextLine()) {
                ++l;
                String line = sc.nextLine();
                String[] tokens = line.split(" ");
                if (tokens.length != 7) {
                    throw new Exception("File " + filename + " (line " + l + "): does not conform to expected format.\n" + line);
                }
                if (tokens[3].equalsIgnoreCase("recv")) {
                    HashSet<DataUnit> list = this.receptionTimes.get(tokens[6]);
                    if (list == null) {
                        list = new HashSet();
                        this.receptionTimes.put(tokens[6], list);
                    }
                    if (list.add(new DataUnit(this, tokens[2], Long.parseLong(tokens[0])))) continue;
                    System.err.println("Message " + tokens[6] + " delivered twice by " + tokens[2]);
                    continue;
                }
                if (tokens[3].equalsIgnoreCase("sent")) {
                    long timestamp = Long.parseLong(tokens[0]);
                    this.transmissionTime.put(tokens[6], new DataUnit(this, tokens[2], timestamp));
                    this.orderedTransmissions.add(new DataUnit(this, tokens[4], timestamp));
                    continue;
                }
                throw new Exception("File " + filename + " (line " + l + "): does not conform to expected format.\n" + line);
            }
        }
        ++this.numberOfProcesses;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("You need at least two log files to process the statistics.");
            System.err.println("Usage: java " + CheckSecureMessageDelivery.class.getCanonicalName() + " [list of log files separated by spaces]");
            System.exit(1);
        }
        CheckSecureMessageDelivery cmd = new CheckSecureMessageDelivery();
        System.err.println("Starting to load files...");
        for (String file : args) {
            System.err.println("Loading file: " + file);
            cmd.addLogFile(file);
        }
        System.err.println("Processing statistics...");
        cmd.processStatistics();
        cmd.printStatistics();
    }

    private void processStatistics() {
        double latencyAccumulator = 0.0;
        double reliabilityAccumulator = 0.0;
        long recordCount = 0L;
        this.inconsistentRecords = 0L;
        for (DataUnit du : this.orderedTransmissions) {
            long sentAt = this.transmissionTime.get((Object)du.label).timestamp;
            HashSet<DataUnit> list = this.receptionTimes.get(du.label);
            if (list == null) {
                ++this.inconsistentRecords;
                continue;
            }
            double reliability = (double)list.size() / (double)this.numberOfProcesses;
            reliabilityAccumulator += reliability;
            this.reliabilityOverTime.add(reliability);
            long maximal = Long.MIN_VALUE;
            Iterator<DataUnit> ite = list.iterator();
            while (ite.hasNext()) {
                long n = ite.next().timestamp;
                if (n <= maximal) continue;
                maximal = n;
            }
            long latency = maximal - sentAt;
            latencyAccumulator += (double)latency;
            this.lantenciesOverTime.add(latency);
            ++recordCount;
        }
        this.averageLatency = latencyAccumulator / (double)recordCount;
        this.averageReliability = reliabilityAccumulator / (double)recordCount;
    }

    private void printStatistics() throws FileNotFoundException {
        System.out.println("A total of " + this.orderedTransmissions.size() + " messages were broadcasted. (" + this.inconsistentRecords + " message had inconsistent records and were discarded)");
        System.out.println("System was running with " + this.numberOfProcesses + " swarm nodes");
        System.out.println("Average Reliability: " + this.averageReliability);
        System.out.println("Average Latency: " + this.averageLatency);
        PrintStream ps = new PrintStream(new FileOutputStream(new File("reliability.txt")));
        for (Double d : this.reliabilityOverTime) {
            ps.println(d);
        }
        ps.close();
        ps = new PrintStream(new FileOutputStream(new File("latency.txt")));
        for (Long l : this.lantenciesOverTime) {
            ps.println(l);
        }
        ps.close();
    }

    private class DataUnit
    implements Comparable<DataUnit> {
        public final String label;
        public final long timestamp;

        public DataUnit(CheckSecureMessageDelivery checkSecureMessageDelivery, String host, long timestamp) {
            this.label = host;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(DataUnit o) {
            return Long.compare(this.timestamp, o.timestamp);
        }

        public int hashCode() {
            return this.label.hashCode();
        }
    }
}

